/********************************************************************************************************
* Donohue and Wolfers (2006) 
* Table 9
* Do the Dezhbakhsh, Rubin, and Shepherd Instruments Have the Predicted
* Effects on Endogenous Deterrence Variables in Their First-Stage Regressions? (1977-1996)
********************************************************************************************************/

clear
set more off
set mem 500m
set mat 800
cd "..."

program define setlags
* Program creates the variables required for models 4-6
	drop if YEAR==76
	drop if COUNTY==51570 & YEAR==80 & MURDO1==0
 	tsset COUNTY YEAR
	* But I'll butcher it slightly
 	egen yr=rank(YEAR), by(COUNTY)
 	tsset COUNTY yr
 	sort COUNTY yr
	* Prepare Table 5 variables
	for Q in any PAMURC PEXECF PEXECP PEXECA PSENTP PSENTF PSENTA: gen Qb=Q
	replace PAMURCb=. if MURDO1==0 & AMUR~=.
	for Q in any PAMURC PEXECF PEXECP PEXECA: for Z in num 1/6: gen QZb=lZ.Qb if Qb==.
	for Z in num 1/6: replace PEXECFZb=0 if PEXECFZb==. & YEAR-Z<77
	for Z in num 1/6: replace PAMURCb=PAMURCZb if PAMURCb==. & MURDO1==0 & AMUR~=.
	for Z in num 1/6: for Q in any PEXECF PEXECP PEXECA: replace Qb=QZb if Qb==.
end

program define firststage
	
	areg  PAMURCb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PAMURCP2b , xbd
	areg  PSENTPb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTPP2b , xbd
	areg  PEXECPb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECPP2b, xbd

end

program define secondstage

	areg RATMUR RATAGA RATROB PAMURCP2b PSENTPP2b PEXECPP2b PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECPP2b]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2b]+1.96*_se[PEXECPP2b])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2b]-1.96*_se[PEXECPP2b])*((2293)/38)/(320/38)-1

end

use "CPcounty5_send.dta", clear
setlags
firststage
secondstage
